/**
 * @file registers the simpleBox toolbar button and binds functionality to it.
 */

import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';
import icon from '../../../../../../../../../core/modules/ckeditor5/icons/medialibrary.svg';

export default class MMMediaLibraryUi extends Plugin {
  init() {
    const editor = this.editor;
    const options = this.editor.config.get('MMMediaLibrary');
    if (!options) {
      return;
    }

    const { libraryURL, openDialog, dialogSettings = {} } = options;
    if (!libraryURL || typeof openDialog !== 'function') {
      return;
    }

    // This will register the toolbar button.
    editor.ui.componentFactory.add('MMMediaLibrary', (locale) => {
      const command = editor.commands.get('insertMMMediaLibrary');
      const buttonView = new ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: editor.t('Insert Media from This Site'),
        icon: icon,
        tooltip: true,
      });

      // Bind the state of the button to the command.
      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

      // Execute the command when the button is clicked (executed).
      this.listenTo(buttonView, 'execute', () => {
        openDialog(
          libraryURL,
          ({ attributes }) => {
            editor.execute('insertMMMediaLibrary', attributes);
          },
          dialogSettings,
        );
      });

      return buttonView;
    });
  }
}
