(function ($) {
  /**
   * Command to refresh an MM Media Library preview.
   *
   * @param {Drupal.Ajax} [ajax]
   *   The ajax object.
   * @param {object} response
   *   Object holding the server response.
   * @param {string} response.media_id
   *   The ID for the Media entity.
   * @param {string} [status]
   *   The HTTP status code.
   */
  Drupal.AjaxCommands.prototype.media_entity_updated = function (ajax, response, status) {
    if (status === 'success') {
      var $hidden = $('.mm-media-library .mm-list-hidden');
      $hidden.val($hidden.val().replace(/\/\d+\/\d+\{/, '/0/' + response.media_id + '{')).change();
    }
  };

  // Without the next two handlers, using the Properties dialog clears out
  // Drupal.ckeditor5.saveCallback when it is closed, and this prevents the
  // media from getting inserted into the CKEditor5 field.
  $(window).on('dialog:beforecreate', function (e, d, el) {
    if (Drupal.hasOwnProperty('ckeditor5') && Drupal.ckeditor5.saveCallback && el.attr('id') === 'mm-media-edit-form') {
      Drupal.ckeditor5.saveSaveCallback = Drupal.ckeditor5.saveCallback;
    }
  });

  $(window).on('dialog:afterclose', function (e, d, el) {
    if (Drupal.ckeditor5.saveSaveCallback && el.attr('id') === 'mm-media-edit-form') {
      Drupal.ckeditor5.saveCallback = Drupal.ckeditor5.saveSaveCallback;
    }
  });

  Drupal.behaviors.mmMediaLibraryEditing = {
    attach: function (context) {
      $(once('mmMediaLibraryCancel', '[data-drupal-selector=edit-cancel]', context))
        .click(function () {
          $(this)
            .closest('.ui-dialog')
            .find('.ui-dialog-titlebar-close')
            .click();
          return false;
        });
      $(once('mmMediaRemoveLinks', '#mmmedialibrary-preview', context))
        .find('a')
        .children()
        .unwrap();
      $(once('mmMediaFixNarrowDialog', 'div.ui-dialog--narrow', context))
        .removeClass('ui-dialog--narrow')
        .css('max-width', '97%');
    }
  };
})(jQuery);
