<?php

namespace Drupal\mm_media\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * AJAX command to refresh an MM Media Library preview.
 */
class MediaUpdatedCommand implements CommandInterface {

  /**
   * Constructor.
   *
   * @param string $mediaId
   *   The ID for the Media entity.
   */
  public function __construct(protected $mediaId) {
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'media_entity_updated',
      'media_id' => $this->mediaId,
    ];
  }

}
