<?php

namespace Drupal\mm_media\Controller;

use Drupal\filter\FilterFormatInterface;
use Drupal\media\Controller\MediaFilterController as MediaFilterControllerAlias;
use Symfony\Component\HttpFoundation\Request;

/**
 * The default CKEditor media preview code can let through <a> tags, which
 * cause the user to leave the editor if they are accidentally clicked.
 * Replace the built-in handler with our own, which sanitizes <a> tags.
 */

class MediaFilterController extends MediaFilterControllerAlias {
  
  /**
   * @inheritDoc
   */
  public function preview(Request $request, FilterFormatInterface $filter_format) {
    $response = parent::preview($request, $filter_format);

    $old_error_handlers = libxml_use_internal_errors(TRUE);
    $dom = new \DOMDocument();
    $dom->loadHTML($response->getContent());
    $atags = $dom->getElementsByTagName('a');

    foreach ($atags as $atag) {
      $atag->setAttribute('onclick', 'return false;');
    }

    $response->setContent($dom->saveHTML());
    libxml_use_internal_errors($old_error_handlers);
    return $response;
  }

}
