<?php
/**
 * @file
 * Contains \Drupal\monster_menus\Element\MMNodelist.
 */

namespace Drupal\mm_media\Element;

use Drupal\Core\Render\Attribute\FormElement;
use Drupal\mm_media\Plugin\MMTreeBrowserDisplay\Media;
use Drupal\monster_menus\Element\MMCatlist;

/**
 * Provides a graphical chooser for nodes within the MM Tree.
 */
#[FormElement('mm_medialist')]
class MMMedialist extends MMCatlist {

  /**
   * @inheritdoc
   */
  public function getInfo() {
    return [
      '#mm_list_mode' => Media::BROWSER_MODE_MEDIA,
    ] + parent::getInfo();
  }

  /**
   * @inheritdoc
   */
  public static function preRender($element) {
    static::preRenderMMList($element['#mm_list_mode'], $element,
      $element['#mm_list_popup_root'] ?? '', 'mm-medialist',
      '', '', '<span class="summary"></span>', static::defaultDetails(t('Choose Media')));
    return $element;
  }

}
