<?php

namespace Drupal\mm_media\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5Plugin\MediaLibrary;
use Drupal\ckeditor5\Plugin\CKEditor5PluginDefinition;
use Drupal\Core\Access\CsrfTokenGenerator;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Url;
use Drupal\editor\EditorInterface;
use Drupal\media_library\MediaLibraryState;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines the "mmmedialibrary" plugin.
 *
 * @internal
 */
class MMMediaLibrary extends MediaLibrary {

  public function __construct(array $configuration, string $plugin_id, CKEditor5PluginDefinition $plugin_definition, EntityTypeManagerInterface $entity_type_manager, protected CsrfTokenGenerator $csrfTokenGenerator) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $entity_type_manager);
  }

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('csrf_token'),
    );
  }

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $media_type_ids = $this->mediaTypeStorage->getQuery()->execute();

    if ($editor->hasAssociatedFilterFormat()) {
      $media_embed_filter = $editor->getFilterFormat()->filters()->get('media_embed');
      // Optionally limit the allowed media types based on the MediaEmbed
      // setting. If the setting is empty, do not limit the options.
      if (!empty($media_embed_filter->settings['allowed_media_types'])) {
        $media_type_ids = array_intersect_key($media_type_ids, $media_embed_filter->settings['allowed_media_types']);
      }
    }
    if (in_array('image', $media_type_ids, TRUE)) {
      // Move image to first position.
      // This workaround can be removed once this issue is fixed:
      // @see https://www.drupal.org/project/drupal/issues/3073799
      array_unshift($media_type_ids, 'image');
      $media_type_ids = array_unique($media_type_ids);
    }

    $state = MediaLibraryState::create(
      'media_library.opener.editor',
      $media_type_ids,
      reset($media_type_ids),
      1,
      ['filter_format_id' => $editor->getFilterFormat()->id()],
    );

    mm_parse_args($mmtids, $oarg_list, $this_mmtid);
    $library_url = Url::fromRoute('mm_media_library.ui', ['mm_tree' => $this_mmtid ?: mm_home_mmtid(), 'editor' => $editor->id()]);
    $token = $this->csrfTokenGenerator->get($library_url->getInternalPath());
    $library_url->setOption('query', $state->all() + ['token' => $token]);

    $dynamic_plugin_config = $static_plugin_config;
    $dynamic_plugin_config['MMMediaLibrary']['libraryURL'] = $library_url->toString();
    return $dynamic_plugin_config;
  }

}