<?php

namespace Drupal\mm_media;

use Drupal\field\Entity\FieldConfig;
use Drupal\file\Entity\File;
use Drupal\media\Entity\Media;
use Drupal\media\Entity\MediaType;

trait TemporaryMediaTrait {

  function createTemporaryMedia(File $file, $bundle = NULL) {
    if (!$bundle) {
      $bundle = explode('/', $file->getMimeType())[0];
      if (!MediaType::load($bundle)) {
        $bundle = 'file';
      }
    }
    return $this->setTemporaryMediaTargetID(Media::create(['bundle' => $bundle]), $file);
  }

  function setTemporaryMediaTargetID(Media $media, File $file) {
    foreach ($media->getFieldDefinitions() as $field) {
      if ($field instanceof FieldConfig && $field->getFieldStorageDefinition()->getSetting('target_type') === 'file') {
        $media->set($field->getName(), ['target_id' => $file->id()]);
        return $media;
      }
    }
    return $media;
  }

}