<?php

namespace Drupal\mm_webform\Form;

use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

trait MMWebformSubmitHandlerTrait {

  protected $routeMatch;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->routeMatch = $container->get('current_route_match');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $params = $this->routeMatch->getParameters();
    $form_state->setRedirect('mm_webform.handlers', [
      'mm_tree' => $params->get('mm_tree')->id(),
      'node' => $params->get('node')->id(),
    ]);
  }

}
