(function ($, Drupal) {
  var recursive = 0;

  Drupal = $.extend(true, Drupal, {
    mmListCallbacks: {
      //------- RSS Page callbacks -------
      rssAddCallback: function (pf, row) {
        // args: 0=type, 1=data, 2=longPath
        Drupal.mmListCallbacks.catReplCallback(pf, row);
        Drupal.mmListCallbacks.listAddCallback(pf, row);
        row.on('change', '.mm-list-rss-select', null, function (e, init) {
          var o = $(this), type;
          // Remove "choose" option.
          if (this.options[0].value === '') {
            $('option:first', o).remove();
          }
          row[0].mmListArgs[0] = type = o.val();
          if (!init) {
            row[0].mmListArgs[1] = row[0].mmListArgs[2] = row[0].mmListArgs[3] = '';
            row.find('.info .description').html('');
          }
          var curr = $('#feed-' + type, row).removeClass('mm-list-hidden');
          $('[id^=feed-]', row).not(curr)
            .addClass('mm-list-hidden')
            .hide(250, function () {
              curr.show(250, function () {
                if (!e.isTrigger) {
                  $('input:first', this).focus();
                }
              });
            });
          if (!e.isTrigger) {
            pf.setSelected(row);
          }
          pf.setHiddenElt(!init);
        })
        .on('change', '[name^=url_]', null, function () {
          $('.mm-list-info', row).remove();
        });
      },
      rssInfoCallback: function (pf, row) {
        return row[0].mmListArgs[3];
      },
      rssReplCallback: function (pf, row) {
        $('summary span.summary:first', row).html(row[0].mmListArgs[1]);
        return row[0].mmListArgs[3];
      },
      rssDataCallback: function (pf, row) {
        return '{:' + row[0].mmListArgs[1] + ':}{:' + row[0].mmListArgs[0] + ':}{:' + row[0].mmListArgs[2] + ':}';
      },
      rssUpdateOnChangeCallback: function (pf, row, init) {
        Drupal.mmListCallbacks.listUpdateOnChangeCallback(pf, row, init);
        if (!recursive++ && init) {
          $('.mm-list-rss-select', row).trigger('change', true);
          pf.setHiddenElt(init);
        }
        recursive--;
      },
      rssAutocompleteCallback: function (pf, row, event, ui) {
        $(event.target).val(row[0].mmListArgs[1] = ui.item.label);
        row[0].mmListArgs[2] = ui.item.value;
        pf.setHiddenElt();
        return ui.item.label;
      }
    }
  });
})(jQuery, Drupal);
