<?php

namespace Drupal\rss_page\FeedDataFetcher;

use Drupal\Core\Database\Connection;
use Drupal\Core\Url;
use Drupal\monster_menus\Constants;
use Drupal\node\NodeInterface;
use Drupal\rss_page\FeedDataFetcher\FeedData;

class FeedDataFetchCat implements FeedDataFetcherInterface {

  /**
   * {@inheritdoc}
   */
  public static function fetch($feed, Connection $db, NodeInterface $node, $index, $mark, $atime, &$newest, &$new_rss_link) {
    $link = NULL;
    $out = new FeedData();
    if (!mm_content_user_can($feed->data, Constants::MM_PERMS_READ)) {
      $out = new FeedData(['error' => t('You are not allowed to read the page %cat.', ['%cat' => $feed->name])]);
    }
    else {
      $cat = mm_content_get($feed->data);
      if ($cat) {
        $link = mm_content_get_mmtid_url($feed->data, ['absolute' => TRUE]);
        $out = new FeedData(['items' => [], 'feed_title' => $cat->name, 'show_item_title' => !_rss_page_get_node_value($node, 'show_descr'), 'feed_link' => $link, 'fid' => $feed->fid ?? 0]);
        _rss_page_feed_from_cat($feed->data, NULL, $node, $index, $mark, $atime, $link, $newest, $out);
      }
    }
    $new_rss_link = Url::fromRoute('monster_menus.show_page_feed',
      $link ? $link->getRouteParameters() : ['mm_tree' => mm_home_mmtid()],
      $link ? $link->getOptions() : []);
    return $out;
  }

}