<?php

namespace Drupal\rss_page\FeedDataFetcher;

use Drupal\Core\Database\Connection;
use Drupal\Core\Url;
use Drupal\node\NodeInterface;

class FeedDataFetchTaxon implements FeedDataFetcherInterface {

  public static function fetch($feed, Connection $db, NodeInterface $node, $index, $mark, $atime, &$newest, &$new_rss_link) {
    $out = new FeedData();
    if (!\Drupal::config('taxonomy.settings')->get('maintain_index_table') || !preg_match('{(.*?)\s*\((\d+)\)$}', $feed->data, $matches)) {
      return $out;
    }
    $taxon_tid = $matches[2];
    $nids = array_unique(_rss_page_taxonomy_select_nodes($taxon_tid));

    $link = NULL;
    if ($nids) {
      $link = Url::fromRoute('entity.taxonomy_term.canonical', ['taxonomy_term' => $taxon_tid], ['absolute' => TRUE]);
      $out = new FeedData([
        'items' => [],
        'feed_title' => $matches[1],
        'show_item_title' => !_rss_page_get_node_value($node, 'show_descr'),
        'feed_link' => $link,
        'fid' => $feed->fid ?? 0,
      ]);
      _rss_page_feed_from_cat(NULL, $nids, $node, $index, $mark, $atime, '', $newest, $out);
    }
    $new_rss_link = Url::fromRoute('monster_menus.show_page_feed',
      $link ? $link->getRouteParameters() : ['mm_tree' => mm_home_mmtid()],
      $link ? $link->getOptions() : []);
    return $out;
  }

}