<?php

namespace Drupal\rss_page\FeedDataFetcher;

use Drupal\Core\Database\Connection;
use Drupal\Core\Url;
use Drupal\node\NodeInterface;
use Drupal\rss_page\FeedDataFetcher\FeedData;

interface FeedDataFetcherInterface {

  /**
   * @param object $feed
   * @param Connection $db
   * @param NodeInterface $node
   * @param int $index
   * @param string $mark
   * @param null|int $atime
   * @param int $newest
   * @param Url $new_rss_link
   *
   * @return FeedData
   */
  public static function fetch($feed, Connection $db, NodeInterface $node, $index, $mark, $atime, &$newest, &$new_rss_link);

}