<?php

namespace Drupal\monster_menus\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a MMSearchAction annotation object.
 *
 * MMSearchAction defines an action to be performed with the results of a Search.
 *
 * @see plugin_api
 *
 * @Annotation
 *
 */
class MMSearchAction extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the action.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $label;

  /**
   * The plugin description.
   *
   * @var string
   */
  public $description;

  /**
   * Include drupalSettings from form in the JSON result.
   *
   * @var bool
   */
  public $useDrupalSettings;

  /**
   * Include JS libraries from form in the JSON result.
   *
   * @var bool
   */
  public $useJS;

  /**
   * Javascript initialization function.
   *
   * @var string
   */
  public $jsInit;

}
