<?php

namespace Drupal\monster_menus;

/**
 * @file
 * Various constants used by Monster Menus
 */

class Constants {
  // Constants used in mm_get_node_info() and hook_mm_node_info()
  final public const string MM_NODE_INFO_NO_REORDER = 'no_reorder'; // don't allow this node type to be reordered
  final public const string MM_NODE_INFO_NO_RENDER  = 'no_render';  // don't render this node type
  final public const string MM_NODE_INFO_ADD_HIDDEN = 'add_hidden'; // hide the Add node link for this type

  // Constants used in mm_content_get()
  final public const string MM_GET_ARCHIVE = '_arch';  // return archive status
  final public const string MM_GET_FLAGS   = '_flags'; // return flags
  final public const string MM_GET_PARENTS = '_par';   // return parents

  // Constants used in mm_content_get_tree() and mm_content_get_query()
  final public const string MM_GET_TREE_ADD_SELECT        = '_sel';   // add to list of selected columns
  final public const string MM_GET_TREE_CLASS             = '_class'; // class to use internally for results
  final public const string MM_GET_TREE_BIAS_ANON         = '_bias';  // assume user 0 can't read any groups
  final public const string MM_GET_TREE_DEPTH             = '_depth'; // tree recursion depth
  final public const string MM_GET_TREE_FAKE_READ_BINS    = '_read';  // pretend user has read on all bins (used internally)
  final public const string MM_GET_TREE_FILTER_BINS       = '_bins';  // return recycle bins
  final public const string MM_GET_TREE_FILTER_DOTS       = '_dots';  // return all entries with names starting with '.'
  final public const string MM_GET_TREE_FILTER_GROUPS     = '_grps';  // get groups
  final public const string MM_GET_TREE_FILTER_NORMAL     = '_norm';  // get entries not group or in /users
  final public const string MM_GET_TREE_FILTER_USERS      = '_usrs';  // get entries in /users
  final public const string MM_GET_TREE_INNER_FILTER      = '_inner'; // used internally
  final public const string MM_GET_TREE_MMTID             = '_mmtid'; // tree ID to query
  final public const string MM_GET_TREE_NODE              = '_node';  // node object to query permissions for
  final public const string MM_GET_TREE_RETURN_BINS       = '_rbins'; // return list of parent recycle bins
  final public const string MM_GET_TREE_RETURN_BLOCK      = '_rblk';  // return attributes from the mm_tree_block table
  final public const string MM_GET_TREE_RETURN_FLAGS      = '_rflgs'; // return attributes from the mm_tree_flags table
  final public const string MM_GET_TREE_RETURN_KID_COUNT  = '_rkids'; // return the number of children each entry has
  final public const string MM_GET_TREE_RETURN_MTIME      = '_rmods'; // return the mtime and muid fields
  final public const string MM_GET_TREE_RETURN_NODE_COUNT = '_rnode'; // include a "nodecount" field, containing the number of nodes using this entry
  final public const string MM_GET_TREE_RETURN_PERMS      = '_rprms'; // return whether the user can perform an action
  final public const string MM_GET_TREE_RETURN_TREE       = '_rtree'; // return attributes from the mm_tree table
  final public const string MM_GET_TREE_SORT              = '_sort';  // sort results by weight, alpha, etc.; always TRUE when depth != 0
  final public const string MM_GET_TREE_USER              = '_user';  // user object to test permissions against
  final public const string MM_GET_TREE_WHERE             = '_where'; // add a WHERE clause to the outermost query
  final public const string MM_GET_TREE_FAST              = '_fast';  // use much faster query by sort_idx

  // Constants used only in mm_content_get_tree()
  final public const string MM_GET_TREE_ADD_TO_CACHE  = '_cache'; // add results to the caches used by mm_content_get() and mm_content_get_parents()
  final public const string MM_GET_TREE_BLOCK         = '_block'; // retrieve entries which appear in a particular block
  final public const string MM_GET_TREE_FILTER_HIDDEN = '_hide';  // get "hidden" entries
  final public const string MM_GET_TREE_HERE          = '_here';  // list of tree IDs currently being viewed
  final public const string MM_GET_TREE_ITERATOR      = '_iter';  // GetTreeIterator (or subclass)
  final public const string MM_GET_TREE_PRUNE_PARENTS = '_ppar';  // prune parents depending upon max_parents
  final public const string MM_GET_TREE_VIRTUAL       = '_virt';  // include virtual user list sub-entries

  final public const int MM_GET_TREE_STATE_COLLAPSED = (1<<0);
  final public const int MM_GET_TREE_STATE_DENIED    = (1<<1);
  final public const int MM_GET_TREE_STATE_EXPANDED  = (1<<2);
  final public const int MM_GET_TREE_STATE_HERE      = (1<<3);
  final public const int MM_GET_TREE_STATE_HIDDEN    = (1<<4);
  final public const int MM_GET_TREE_STATE_LEAF      = (1<<5);
  final public const int MM_GET_TREE_STATE_NOT_WORLD = (1<<6);
  final public const int MM_GET_TREE_STATE_RECYCLE   = (1<<7);

  // Constants used in mm_content_copy()
  final public const string MM_COPY_ALIAS              = 'alia';
  final public const string MM_COPY_COMMENTS           = 'comm';
  final public const string MM_COPY_CONTENTS           = 'cont';
  final public const string MM_COPY_ITERATE_ALTER      = 'itra';
  final public const string MM_COPY_NAME               = 'name';
  final public const string MM_COPY_NODE_PRESAVE_ALTER = 'noda';
  final public const string MM_COPY_OWNER              = 'ownr';
  final public const string MM_COPY_READABLE           = 'read';
  final public const string MM_COPY_RECUR              = 'recr';
  final public const string MM_COPY_TREE               = 'tree';
  final public const string MM_COPY_TREE_PRESAVE_ALTER = 'trea';
  final public const string MM_COPY_TREE_SKIP_DUPS     = 'tdup';

  // Constants present in mm_tree.name
  final public const string MM_ENTRY_NAME_DEFAULT_USER  = '.Default';
  final public const string MM_ENTRY_NAME_DISABLED_USER = '.Disabled';
  final public const string MM_ENTRY_NAME_GROUPS        = '.Groups';
  final public const string MM_ENTRY_NAME_LOST_FOUND    = '.LostAndFound';
  final public const string MM_ENTRY_NAME_RECYCLE       = '.Recycle';
  final public const string MM_ENTRY_NAME_SYSTEM        = '.System';
  final public const string MM_ENTRY_NAME_USERS         = '.Users';
  final public const string MM_ENTRY_NAME_VIRTUAL_GROUP = '.Virtual';

  // Constants present in mm_tree.alias
  final public const string MM_ENTRY_ALIAS_SYSTEM     = '-system';
  final public const string MM_ENTRY_ALIAS_LOST_FOUND = 'lost';

  // Constants used in mm_content_get_tree(), _mm_content_get_tree_query(),
  // mm_content_user_can() and mm_content_user_can_node()
  final public const string MM_PERMS_WRITE          = 'w';
  final public const string MM_PERMS_SUB            = 'a';
  final public const string MM_PERMS_APPLY          = 'u';
  final public const string MM_PERMS_READ           = 'r';
  final public const string MM_PERMS_IS_GROUP       = '_isgrp';
  final public const string MM_PERMS_IS_USER        = '_isusr';
  final public const string MM_PERMS_ADMIN          = '_admin';
  final public const string MM_PERMS_IS_RECYCLE_BIN = '_isbin';
  final public const string MM_PERMS_IS_RECYCLED    = '_isrec';
  // Constant used in mm_content_user_can_recycle().
  final public const string MM_PERMS_IS_EMPTYABLE   = 'EMPTY';

  // Constants used for the $mmtid parameter to mm_content_node_is_recycled().
  final public const int MM_NODE_RECYCLED_MMTID_CURR = -1;  // Recycled on the current page
  final public const int MM_NODE_RECYCLED_MMTID_EXCL = 0;   // Recycled on all referring pages

  // The maximum number of sub-items per item in the tree is
  // MM_CONTENT_BTOA_BASE ^ MM_CONTENT_BTOA_CHARS. If you might have more than
  // this many /Users (or any other level of the tree) someday, increase
  // MM_CONTENT_BTOA_CHARS and run mm_content_update_sort(). A larger
  // MM_CONTENT_BTOA_BASE cannot be used, unless you are using a case-sensitive
  // collation on the mmtree.sort_idx database column.
  //
  // The maximum nesting level of the tree is the length of mm_tree.sort_idx /
  // MM_CONTENT_BTOA_CHARS. While you can increase this by altering the schema,
  // you may find that MySQL starts to complain about there being too many tables
  // in the JOIN in monster_menus_url_inbound_alter(). MM_CONTENT_MYSQL_MAX_JOINS
  // is used in monster_menus.install to ensure that this limit isn't exceeded.
  final public const int MM_CONTENT_BTOA_START = 33;   // ord('!')
  final public const int MM_CONTENT_BTOA_BASE  = 64;
  final public const int MM_CONTENT_BTOA_CHARS = 4;

  // When MM tries to turn a long URL into a menu path, it does a JOIN against
  // mm_tree for each path segment. This constant keeps MySQL from reporting an
  // error due to too many JOINs. While this value can technically be 61,
  // experience has shown that performance is so poor with that number, that the
  // server becomes unusable.
  final public const int MM_CONTENT_MYSQL_MAX_JOINS = 40;

  // Constants related to the virtual group "dirty" field
  final public const int MM_VGROUP_DIRTY_NOT       = 0; // not dirty
  final public const int MM_VGROUP_DIRTY_NEXT_CRON = 1; // update during next hook_cron()
  final public const int MM_VGROUP_DIRTY_FAILED    = 2; // previously failed sanity check
  final public const int MM_VGROUP_DIRTY_REDO      = 3; // failed, but OK to regenerate
  // If the count of users in a virtual group decreases by more than this ratio,
  // return an error message and stop the vgroup regeneration. Set the matching
  // record's "dirty" field in mm_vgroup_query to MM_VGROUP_DIRTY_REDO to ignore
  // this condition and regenerate the group during the next run.
  final public const float MM_VGROUP_COUNT_SANITY    = 0.20;

  // Constant used by DefaultController::saveSitemap()
  final public const int MM_SITEMAP_MAX_LEVEL_DEFAULT = 6;

  // Constants used by mm_ui.inc
  final public const int MM_UI_MAX_USERS_IN_GROUP = 20; // max number of users to display (there can be more in the DB)
  final public const int MM_UI_MAX_REORDER_ITEMS = 100; // max number of nodes/subpages to reorder

  // hook_mm_showpage_routing() page removal prevention modes
  final public const string MM_PREVENT_SHOWPAGE_REMOVAL_NONE = '';
  final public const string MM_PREVENT_SHOWPAGE_REMOVAL_WARN = 'warn';
  final public const string MM_PREVENT_SHOWPAGE_REMOVAL_HALT = 'halt';

  // Search feature: Set this value to TRUE to enable some debugging messages and
  // to see the search query submitted via AJAX.
  final public const bool MMSR_debug = FALSE;

  // Miscellaneous Constants

  final public const int MM_HOME_MMTID_DEFAULT = 7;
  final public const string MM_COMMENT_READABILITY_DEFAULT = 'comment readability default';  // permission name

  // Block IDs
  final public const string MM_MENU_BID     = '1';  // block ID (bid) containing the page section title
  final public const string MM_MENU_DEFAULT = '0';  // block ID (bid) neutral default
  final public const string MM_MENU_UNSET   = '-1'; // block ID (bid) when unspecified

  final public const int MM_DEFAULT_NODES_PER_PAGE       = 10;
  final public const int MM_LAZY_LOAD_NUMBER_OF_NODES    = 10; // If the lazy loader is used to get nodes for a page, this is the number of nodes it gets per chunk
  final public const int MM_MAX_NUMBER_OF_NODES_PER_PAGE = 500; // In cases where all the nodes are loaded for a particular page, limit the number returned (a value of 0 here bypasses this check)

  // Max. number of items to auto-delete from recycle bins during a cron run
  final public const int MM_CRON_EMPTY_BINS_LIMIT = 500;

  final public const string MM_LARGE_GROUP_TOKEN = 'mm_large_group_token';

  // Max. number of results to display at admin/mm/fix-nodes
  final public const int MM_ADMIN_NODE_URL_PREVIEW_COUNT = 50;

  // Name of the default page region
  final public const string MM_UI_REGION_CONTENT = 'content';

  // The default age, in seconds, after which to act on unchanged user homepages
  final public const int MM_UNMODIFIED_HOMEPAGES_MAX_AGE = 30 * 24 * 60 * 60;

  final public const string MM_NODE_ACCESS_ALLOW  = 'allow';
  final public const string MM_NODE_ACCESS_DENY   = 'deny';

  final public const string MM_VQUERY_PHP = '[php]';
}
