<?php
/**
 * @file
 * Contains \Drupal\monster_menus\Element\MMGrouplist.
 */

namespace Drupal\monster_menus\Element;

use Drupal\Core\Render\Attribute\FormElement;
use Drupal\monster_menus\Plugin\MMTreeBrowserDisplay\Groups;

/**
 * Provides a graphical chooser for MM Tree group entries.
 */
#[FormElement('mm_grouplist')]
class MMGrouplist extends MMCatlist {

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function getInfo() {
    return [
        '#mm_list_mode' => Groups::BROWSER_MODE_GROUP,
      ] + parent::getInfo();
  }

  public static function preRender($element) {
    $info_label = mm_ui_is_search() ? '' : t('Users in selected group:');
    $details = [
      'choose' => [
        '#type' => 'button',
        '#attributes' => ['class' => ['mm-list-button-edit']],
        '#value' => t('Choose a Group'),
      ],
    ];
    parent::preRenderMMList($element['#mm_list_mode'], $element, mm_content_groups_mmtid(), 'mm-grouplist', $info_label, '', '<span class="summary"></span>', \Drupal::service('renderer')->render($details));
    return $element;
  }

  // Helper function to pre-generate an entry in the list.
  public static function makeEntry($mmtid, $name, &$url, &$info, &$popup_URL, &$elt) {
    $parents = mm_content_get_parents($mmtid);
    array_shift($parents);  // skip root
    $url = implode('/', $parents);

    if (!isset($popup_URL)) {
      $popup_URL = $url;
    }

    $url .= "/$mmtid";

    $info = mm_content_get_users_in_group($mmtid, '<br />', FALSE, 20, TRUE, $elt);
    if ($info == '') {
      $info = t('(none)');
    }
  }

}