<?php
/**
 * @file
 * Contains \Drupal\monster_menus\Element\MMNodelist.
 */

namespace Drupal\monster_menus\Element;

use Drupal\Core\Render\Attribute\FormElement;
use Drupal\monster_menus\Plugin\MMTreeBrowserDisplay\Nodes;

/**
 * Provides a graphical chooser for nodes within the MM Tree.
 */
#[FormElement('mm_nodelist')]
class MMNodelist extends MMCatlist {

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function getInfo() {
    return [
        '#mm_list_mode' => Nodes::BROWSER_MODE_NODE,
      ] + parent::getInfo();
  }

  public static function preRender($element) {
    static::preRenderMMList($element['#mm_list_mode'], $element, $element['#mm_list_popup_root'], 'mm-nodelist',
      '', '', '<span class="summary"></span>', static::defaultDetails(t('Choose Content')));
    return $element;
  }

}
