<?php
/**
 * @file
 * Contains \Drupal\monster_menus\Element\MMUserlist.
 */

namespace Drupal\monster_menus\Element;

use Drupal\Core\Render\Attribute\FormElement;
use Drupal\monster_menus\Plugin\MMTreeBrowserDisplay\Users;

/**
 * Provides a graphical user chooser.
 */
#[FormElement('mm_userlist')]
class MMUserlist extends MMCatlist {

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function getInfo() {
    $info = parent::getInfo();
    unset($info['#mm_list_info_func']);
    $info['#mm_list_mode'] = Users::BROWSER_MODE_USER;
    return $info;
  }

  public static function preRender($element) {
    $autocomplete_name = MMCatlist::getAutocompleteName($element);
    $info = '';
    if (mm_ui_is_search()) {
      $element['#required'] = FALSE;
    }
    else if (!empty($element[$autocomplete_name]['#description'])) {
      $info = (string) $element[$autocomplete_name]['#description'];
    }
    $element[$autocomplete_name]['#description'] = '';
    if (!isset($element[$autocomplete_name]['#placeholder'])) {
      $element[$autocomplete_name]['#placeholder'] = t("User's Name");
    }
    $element[$autocomplete_name]['#name'] = end($element[$autocomplete_name]['#parents']);
    $field_tag = \Drupal::service('renderer')->render($element[$autocomplete_name]);
    static::preRenderMMList($element['#mm_list_mode'], $element, 0, 'mm-userlist', '', $info, $field_tag);
    unset($element[$autocomplete_name]);
    return $element;
  }

}