<?php

namespace Drupal\monster_menus\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Template\Attribute;

class AddGroupUsersForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'mm_ui_large_group_add_users';
  }

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    [$instance, $link_id, $title, $button_text, $click_func_name, $owner_uid, $owner_name] = $form_state->getBuildInfo()['args'];
    if (!$this->currentUser()->hasPermission('access user profiles')) {
      $form[] = _mm_ui_no_add_user();
      return $form;
    }

    $single = is_null($owner_uid) ? 0 : 1;
    $users = [];
    if ($single) {
      $users[$owner_uid] = $owner_name;
    }
    else {
      $users[0] = '';
    }
    $form['selectuser']["adduser$instance"] = [
      '#type' => 'mm_userlist',
      '#title' => $title,
      '#required' => $single,
      '#default_value' => $users,
      '#mm_list_autocomplete_name' => "adduser-choose$instance",
      '#mm_list_min' => 1,
      '#mm_list_max' => $single ? 1 : 0,
      '#mm_list_submit_on_add' => $single,
      "adduser-choose$instance" => [
        '#type' => 'textfield',
        '#title' => '',
        '#autocomplete_route_name' => 'monster_menus.autocomplete',
        '#description' => mm_autocomplete_desc(),
        '#size' => 30,
        '#attributes' => ['autofocus' => 'autofocus'],
      ],
    ];
    $form["adduser$instance-submit"] = [
      '#name' => "adduser$instance-submit",
      '#type' => 'submit',
      '#value' => $button_text,
    ];
    $attr = new Attribute($form['#attributes']);
    $attr['onsubmit'] = "return $click_func_name(jQuery(this).find('.mm-list-hidden'), '$link_id');";
    $form['#attributes'] = $attr->toArray();
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
  }

}
