<?php

namespace Drupal\monster_menus\Form;

use Drupal\Core\Url;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\monster_menus\Constants;
use Drupal\user\Entity\User;
use Drupal\user\UserInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

class ListUsersForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'mm_ui_user_list';
  }

  /**
   * {@inheritdoc}
   * @return mixed[]
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    _mm_ui_userlist_setup([0 => ''], $form, 'userlist', $this->t("User's name"), TRUE, '');
    $form['userlist']['userlist-choose']['#title'] = '';
    $form['actions'] = ['#type' => 'actions'];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('View Homepage'),
      '#button_type' => 'primary',
    ];
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $uid = mm_ui_mmlist_key0($form_state->getValue('userlist'));

    if (isset($uid) && ($home = mm_content_get(['f.flag' => 'user_home', 'f.data' => intval($uid)], Constants::MM_GET_FLAGS)) && !mm_content_is_recycled($home[0]->mmtid)) {
      mm_set_form_redirect_to_mmtid($form_state, $home[0]->mmtid);
    }
    else {
      /** @var UserInterface|null $usr */
      $usr = User::load($uid);
      if ($usr && $usr->isActive()) {
        $form_state->setResponse(new RedirectResponse(Url::fromRoute('entity.mm_tree.canonical', ['mm_tree' => mm_content_users_mmtid()], ['absolute' => TRUE])->toString() . '/' . $usr->getAccountName()));
      }
      else {
        $this->messenger()->addStatus($this->t('The selected user does not have a homepage.'));
      }
    }
  }

}
