<?php
namespace Drupal\monster_menus;

use Drupal\Core\Database\Database;

/**
 * Class used internally, to provide the ability to store the most recent
 * result and re-retrieve it later.
 */
class GetTreeResults {

  private $query_obj;
  /** @var MMSimpleItemInterface */
  private $prev;
  private $backed;

  const PAGE_SIZE = 1000;
  private $page = 0;
  private $count;
  private $ended = FALSE;

  public $start_level, $level_offset;

  /**
   * @param $query
   *   The SQL query.
   * @param $result_class
   *   The class of the result object.
   * @param $allow_delimiter
   *   If TRUE, allow the delimiter character (usually ';') in the query.
   */
  public function __construct(private $query, private $result_class, private $allow_delimiter) {
    $this->query();
  }

  private function query() {
    $options = $this->allow_delimiter ? ['allow_delimiter_in_query' => TRUE] : [];
    $this->query_obj = Database::getConnection()->query($this->query . ' LIMIT ' . ($this->page++ * self::PAGE_SIZE) . ', ' . self::PAGE_SIZE, [], $options);
    $this->count = 0;
  }

  public function next() {
    if (!empty($this->backed)) {
      $this->backed = FALSE;
      return $this->prev;
    }
    if ($this->ended) {
      return FALSE;
    }
    if ($this->count == self::PAGE_SIZE) {
      $this->query();
    }
    $result = $this->query_obj->fetchObject();
    $this->prev = $result ? new $this->result_class($result) : FALSE;
    $this->count++;
    $this->ended = $this->prev === FALSE && $this->count < self::PAGE_SIZE;
    return $this->prev;
  }

  public function back() {
    $this->backed = TRUE;
  }

}
