<?php

namespace Drupal\monster_menus\MMCreatePath;

use Drupal\monster_menus\Constants;

class MMCreatePathCat extends MMCreatePathBase {

  public
    $type = 'cat',
    $default_mode = Constants::MM_PERMS_READ,
    $max_depth = -1,
    $max_parents = -1,
    $menu_start = -1,
    $node_info = 3,
    $previews = 0;

  public $cascaded = [
    'allow_reorder' => -1,
    'allowed_themes' => NULL,
    'allowed_node_types' => NULL,
    'hide_menu_tabs' => -1,
  ];

  public function __construct($arr) {
    foreach ($arr as $key => $val) {
      if ($key == 'cascaded') {
        foreach ($val as $ckey => $cval) {
          $this->cascaded[$ckey] = $cval;
        }
      }
      else if (property_exists($this, $key)){
        $this->{$key} = $val;
      }
    }
  }

}