<?php

namespace Drupal\monster_menus;

use Drupal\Component\Serialization\Json;
use Stringable;

class MMOargsStringable implements Stringable {

  protected $oargs;

  /**
   * Constructor.
   *
   * @param array $oargs
   *   The array of oargs to be stored.
   */
  public function __construct(array $oargs) {
    $this->oargs = $oargs;
  }

  /**
   * @inheritDoc
   */
  public function __toString(): string {
    return Json::encode($this->oargs);
  }

  /**
   * @inheritDoc
   */
  public function getValue() {
    return $this->oargs;
  }

}
