<?php

namespace Drupal\monster_menus;

class MMSimpleItem implements MMSimpleItemInterface {

  // Properties taken from the mm_tree table.
  public
    $mmtid,
    $uuid,
    $vid,
    $uid,
    $name,
    $alias,
    $parent,
    $default_mode,
    $weight,
    $theme,
    $sort_idx,
    $sort_idx_dirty,
    $hover,
    $rss,
    $ctime,
    $cuid,
    $mtime,
    $muid,
    $node_info,
    $previews,
    $hidden,
    $comment;

  // Properties derived from related tables.
  public
    $flags,
    $level,
    $parents;

  // Properties related to archive pages.
  public
    $archive_cached,
    $main_mmtid,
    $archive_mmtid,
    $frequency,
    $main_nodes;

  // Properties related to blocks.
  public
    $bid,
    $max_depth,
    $max_parents;

  // Properties derived by mm_content_get_tree().
  public
    $is_group,
    $is_user,
    $is_user_home,
    $state,
    $perms,
    $nodecount;

  /**
   * @inheritdoc
   */
  public function __construct($defaults) {
    foreach ((array) $defaults as $name => $value) {
      if (!property_exists($this, $name)) {
        if (!($defaults instanceof GetTreeResult) || !property_exists($defaults, $name)) {
          throw new \InvalidArgumentException("Property '$name' does not exist.");
        }
        continue;
      }
      $this->{$name} = $value;
    }
  }

}