<?php
namespace Drupal\monster_menus;

// Referred by monster_menus.permissions.yml

class Permissions {
  public function permissions() {
    $perms = [];
    if (mm_get_setting('comments.finegrain_readability')) {
      foreach (mm_get_setting('comments.readable_labels') as $label) {
        $perms[$label['perm']] = ['title' => t('<em>Comment readability:</em> @perm', ['@perm' => $label['desc']])];
      }
      $perms[Constants::MM_COMMENT_READABILITY_DEFAULT] = ['title' => t('<em>Comment readability:</em> @perm', ['@perm' => t('can read comments by default')]), 'description' => t('When no other comment readability setting is applied to a node, roles checked here will be able to read the comments')];
    }

    return $perms;
  }
}