<?php

namespace Drupal\monster_menus\Plugin\MMSearchAction;

use Drupal\Core\Form\EnforcedResponseException;
use Drupal\Core\StringTranslation\TranslatableMarkup;

trait ResultsTrait {

  public $countAllowed = 0, $countChanged = 0;

  /**
   * @return TranslatableMarkup
   */
  private function getResults($add = '') {
    $result_count = $this->getConfiguration('result_count');
    $add = ['@add' => $add];
    if (!$this->countAllowed) {
      return $this->t('<span>@add You are not allowed to change any of the items.</span>', $add);
    }

    if (!$this->countChanged) {
      if ($this->countAllowed == $result_count) {
        return $this->t('<span>@add No changes are needed.</span>', $add);
      }
      return $this->formatPlural($this->countAllowed, '<span>@add The one item you are allowed to change does not need it.</span>', '<span>@add None of the @count items you are allowed to change need it.</span>', $add);
    }

    if ($this->countChanged == $result_count) {
      return $this->t('<span>@add All items will be changed.</span>', $add);
    }

    return $this->formatPlural($this->countAllowed, '<span>@add The one item you are allowed to change will be affected.</span>', '<span>@add Of the @count items you are allowed to change, @changed will be affected.</span>', $add + ['@count' => $this->countAllowed, '@changed' => $this->countChanged]);
  }

  /**
   * @return mixed
   * @throws \Drupal\Core\Form\EnforcedResponseException
   */
  private function returnResults($update_needed) {
    if ($update_needed) {
      throw new EnforcedResponseException(mm_json_response([
        'action_result' => $this->t('<span>Done.</span>'),
        'action_result_div' => '#mmsr-mp-status-text',
        'action_result_js' => 'MMSR_action_modify_perms_update',
        'mp_enable' => FALSE,
      ]));
    }

    throw new EnforcedResponseException(mm_json_response([
      'action_result' => $this->getResults(),
      'action_result_div' => '#mmsr-mp-status-text',
      'action_result_js' => 'MMSR_action_modify_perms_update',
      'mp_enable' => $this->countChanged,
    ]));
  }

}
