<?php

namespace Drupal\Tests\monster_menus\Unit\Controller;

use Drupal\Core\Database\Connection;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Render\Renderer;
use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\Extension\ModuleExtensionList;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\monster_menus\Controller\MMTreeBrowserController;

/**
 * @coversDefaultClass \Drupal\monster_menus\Controller\MMTreeBrowserController
 * @group monster_menus
 */
class MMTreeBrowserControllerTest extends UnitTestCase {

  /**
   * The mocked database connection.
   *
   * @var \Drupal\Core\Database\Connection|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $database;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->database = $this->createMock(Connection::class);
  }

  /**
   * Test the static create method.
   */
  public function testCreate() {
    $request_stack = $this->createMock(RequestStack::class);
    $request_stack->expects($this->any())
      ->method('getCurrentRequest')
      ->willReturn($this->createMock(Request::class));

    $renderer = $this->createMock(Renderer::class);
    $plugin_manager = $this->createMock(PluginManagerInterface::class);
    $module_extension_list = $this->createMock(ModuleExtensionList::class);
    $module_handler = $this->createMock(ModuleHandlerInterface::class);

    $container = $this->createMock(ContainerInterface::class);
    $container->expects($this->any())
      ->method('get')
      ->willReturn($this->database, $request_stack, $renderer, $plugin_manager, $module_extension_list, $module_handler);

    // @phpstan-ignore method.alreadyNarrowedType
    $this->assertInstanceOf(MMTreeBrowserController::class, MMTreeBrowserController::create($container));
  }
}