<?php

namespace Drupal\Tests\monster_menus\Unit\Controller;

use Drupal\Core\Database\Connection;
use Drupal\Core\Render\Renderer;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\monster_menus\Controller\MMTreeViewController;

/**
 * @coversDefaultClass \Drupal\monster_menus\Controller\MMTreeViewController
 * @group monster_menus
 */
class MMTreeViewControllerTest extends UnitTestCase {

  /**
   * The mocked database connection.
   *
   * @var \Drupal\Core\Database\Connection|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $database;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->database = $this->createMock(Connection::class);
  }

  /**
   * Test the static create method.
   */
  public function testCreate() {
    $renderer = $this->createMock(Renderer::class);

    $container = $this->createMock(ContainerInterface::class);
    $container->expects($this->any())
      ->method('get')
      ->willReturn($this->database, $renderer);

    // @phpstan-ignore method.alreadyNarrowedType
    $this->assertInstanceOf(MMTreeViewController::class, MMTreeViewController::create($container));
  }

}