<?php

namespace Drupal\Tests\monster_menus\Unit;

use Prophecy\PhpUnit\ProphecyTrait;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Cache\Context\CacheContextsManager;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\monster_menus\MMTreeAccessControlHandler;

/**
 * @coversDefaultClass \Drupal\monster_menus\MMTreeAccessControlHandler
 * @group monster_menus
 */
class MMTreeAccessControlHandlerTest extends UnitTestCase {

  use ProphecyTrait;

  /**
   * The mocked class instance.
   *
   * @var TestMMTreeAccessControlHandler
   */
  protected $MMTreeAccessControlHandler;

  /**
   * The mocked entity type.
   *
   * @var \Drupal\Core\Entity\EntityTypeInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityType;

  /**
   * The dependency injection container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerBuilder
   */
  protected $container;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->entityType = $this->createMock(EntityTypeInterface::class);

    $this->MMTreeAccessControlHandler = new TestMMTreeAccessControlHandler($this->entityType);

    $this->container = new ContainerBuilder();
    $cache_contexts_manager = $this->prophesize(CacheContextsManager::class);
    $cache_contexts_manager->assertValidTokens([])->willReturn(TRUE);
    $cache_contexts_manager->reveal();
    $this->container->set('cache_contexts_manager', $cache_contexts_manager);
    \Drupal::setContainer($this->container);
  }

  /**
   * {@inheritdoc}
   */
  protected function tearDown(): void {
    parent::tearDown();
    $container = new ContainerBuilder();
    \Drupal::setContainer($container);
  }

  /**
   * Test for 'checkCreateAccess'.
   *
   * @covers ::checkCreateAccess
   */
  public function testCheckCreateAccess() {
    $class = new \ReflectionClass(MMTreeAccessControlHandler::class);
    $method = $class->getMethod('checkCreateAccess');

    $contexts = ['user.permissions'];
    $account = $this->prophesize(AccountInterface::class);
    $entity = $this->prophesize(EntityTypeInterface::class)->reveal();
    $account->hasPermission('add mm page entities')->willReturn(TRUE);
    $this->assertEquals(AccessResult::allowed()->addCacheContexts($contexts), $method->invokeArgs($this->MMTreeAccessControlHandler, [$account->reveal(), $contexts, $entity]));

    $account = $this->prophesize(AccountInterface::class);
    $account->hasPermission('add mm page entities')->willReturn(FALSE);
    $this->assertEquals(AccessResult::neutral("The 'add mm page entities' permission is required.")->addCacheContexts($contexts), $method->invokeArgs($this->MMTreeAccessControlHandler, [$account->reveal(), $contexts, $entity]));
  }

}

/**
 * Tests MMTreeAccessControlHandler.
 */
class TestMMTreeAccessControlHandler extends MMTreeAccessControlHandler {

  /**
   * Allows access to the protected checkCreateAccess method.
   */
  public function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return parent::checkCreateAccess($account, $context, $entity_bundle);
  }

}