<?php

namespace Drupal\more_fields\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * Plugin implementation of the 'experience_formatter_type' formatter.
 *
 * @FieldFormatter(
 *   id = "more_fields_experience2",
 *   label = @Translation(" Experience formatter model avec les dates en dessous "),
 *   field_types = {
 *     "more_fields_experience_type"
 *   }
 * )
 */
class Experience2FormatterType extends ExperienceFormatterType {
  
  /**
   *
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    
    foreach ($items as $delta => $item) {
      $date_debut = '';
      if (!empty($item->date_debut)) {
        $date_debut = DrupalDateTime::createFromTimestamp($item->date_debut);
        $date_debut = $date_debut->format("m/Y");
      }
      
      $date_fin = '';
      if (!empty($item->date_fin)) {
        $date_fin = DrupalDateTime::createFromTimestamp($item->date_fin);
        $date_fin = $date_fin->format("m/Y");
      }
      
      $elements[$delta] = [
        '#theme' => 'more_fields_experience_formatter2',
        '#item' => [
          'value' => Html::escape($item->value),
          'company' => Html::escape($item->company),
          'date_debut' => $date_debut,
          'date_fin' => $date_fin,
          'description' => $item->description
        ]
      ];
    }
    
    return $elements;
  }
  
}
