<?php

namespace Drupal\more_fields\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Field\Annotation\FieldWidget;
use Drupal\Core\Annotation\Translation;
use phpDocumentor\Reflection\Types\This;

/**
 * Plugin implementation of the 'more_fields_accordion_field' widget.
 *
 * @FieldWidget(
 *   id = "more_fields_accordion_field_widget",
 *   module = "more_fields",
 *   label = @Translation("Accordion field widget type"),
 *   field_types = {
 *     "more_fields_accordion_field"
 *   }
 * )
 */
class AccordionFieldWidget extends WidgetBase {
  
  /**
   *
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      'label_1' => "Title",
      'label_2' => "Icon",
      'label_3' => "Description"
    ] + parent::defaultSettings();
  }
  
  /**
   *
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $elements['label_1'] = [
      '#type' => 'textfield',
      '#title' => t('label 1'),
      '#default_value' => $this->getSetting('label_1')
    ];
    $elements['label_2'] = [
      '#type' => 'textfield',
      '#title' => t('label 2'),
      '#default_value' => $this->getSetting('label_2')
    ];
    $elements['label_3'] = [
      '#type' => 'textfield',
      '#title' => t('label 3'),
      '#default_value' => $this->getSetting('label_3')
    ];
    return $elements;
  }
  
  /**
   *
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    return $summary;
  }
  
  /**
   *
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    if (!empty($element['#title_display']))
      unset($element['#title_display']);
    $elts['field'] = [
      '#type' => 'details',
      '#title' => $items[$delta]->title ? $this->getTitleDisplay($items[$delta]->title) : t('Title + Description + icon '),
      '#weight' => 10,
      '#open' => false,
      '#tree' => True
    ];
    $elts['field']['title'] = [
      '#title' => $this->t('Title'),
      '#type' => 'text_format',
      '#format' => isset($items[$delta]->format) ? $items[$delta]->format : 'full_html',
      '#weight' => 0,
      '#default_value' => isset($items[$delta]->title) ? $items[$delta]->title : NULL,
      '#rows' => 2,
      '#cols' => 50
    ] + $element;
    //
    $elts['field']['icon'] = [
      '#title' => $this->t('Icon'),
      '#type' => 'text_format',
      '#format' => isset($items[$delta]->format) ? $items[$delta]->format : 'full_html',
      '#weight' => 2,
      '#default_value' => isset($items[$delta]->icon) ? $items[$delta]->icon : NULL,
      '#rows' => 3,
      '#cols' => 50
    ] + $element;
    //
    $elts['field']['description'] = [
      '#title' => $this->t('Description'),
      '#format' => isset($items[$delta]->format) ? $items[$delta]->format : 'full_html',
      '#type' => 'text_format',
      '#weight' => 0,
      '#default_value' => isset($items[$delta]->description) ? $items[$delta]->description : NULL,
      '#rows' => 5,
      '#cols' => 50
    ] + $element;
    return $elts;
  }
  
  function massageFormValues($values, $form, $form_state) {
    $vals = parent::massageFormValues($values, $form, $form_state);
    foreach ($vals as $k => &$val) {
      // si le titre est vide, on ignore l'element.
      if (empty($val['field']['title']['value'])) {
        unset($vals[$k]);
        continue;
      }
      // Get Format, on tient compte du format de la description.
      if (isset($val['field']['description']['format'])) {
        $val['format'] = $val['field']['description']['format'];
      }
      // on recupere les données.
      $val['description'] = $val['field']['description']['value'];
      $val['icon'] = $val['field']['icon']['value'];
      $val['title'] = $val['field']['title']['value'];
    }
    return $vals;
  }
  
  protected function getTitleDisplay($title) {
    $title = strip_tags($title);
    if (!empty($title)) {
      if (strlen($title) > 70)
        $title = substr($title, 0, 70);
    }
    return $title;
  }
}
