<?php

declare(strict_types=1);

namespace Drupal\more_select_widgets_test\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for more_select_widgets_test.
 */
class MyHooks {

  /**
   * Implements hook_options_list_alter().
   */
  #[Hook('options_list_alter')]
  public function optionsListAlter(array &$options, array $context): void {
    // Add extra options to the select list.
    if ($context['fieldDefinition']->getName() === 'field_filtered_select' && $context['widget']->getPluginId() === 'filterable_select') {
      $options['extra_key'] = 'extra_value';
    }
    if ($context['fieldDefinition']->getName() === 'field_taxonomy_select' && $context['widget']->getPluginId() === 'taxonomy_select') {
      $options['extra_tax'] = 'extra_tax';
    }
  }

}
