<?php
// phpcs:ignoreFile Drupal.Commenting.VariableComment.Missing

namespace Drupal\Tests\more_select_widgets\Functional;

use Drupal\Core\Language\LanguageInterface;
use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\taxonomy\Entity\Term;
use Drupal\taxonomy\Entity\Vocabulary;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\ConfigTestTrait;

/**
 * To be extended by other test classes.
 */
abstract class MoreSelectWidgetsBase extends BrowserTestBase {

  use ConfigTestTrait;
  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'options',
    'more_select_widgets',
    'taxonomy',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  protected string $filteredFieldName = 'field_filtered_select';
  protected string $taxonomyFieldName = 'field_taxonomy_select';
  protected $vocabulary;

  /**
   * {@inheritdoc}
   */
  protected function setUp() : void {
    parent::setUp();
    $this->drupalCreateContentType(['type' => 'select', 'name' => 'Test Select']);

    /* Add a field that uses FilterableSelectWidget */
    $fieldStorageFilteredSelect = [
      'field_name' => $this->filteredFieldName,
      'entity_type' => 'node',
      'type' => 'list_string',
      'settings' => [
        'allowed_values' => ['portkey' => 'port', 'stbdkey' => 'stbd'],
      ],
    ];
    FieldStorageConfig::create($fieldStorageFilteredSelect)->save();
    $fieldFilteredSelect = [
      'field_name' => $this->filteredFieldName,
      'entity_type' => 'node',
      'bundle' => 'select',
      'label' => 'Filtered Select',
    ];
    FieldConfig::create($fieldFilteredSelect)->save();

    /* add a field that uses TaxonomySelectWidget */
    $this->vocabulary = $this->createVocabulary('Test Vocabulary');
    $this->addTerms($this->vocabulary, ['porttax', 'stbdtax']);

    $fieldStorageTaxonomySelect = [
      'field_name' => $this->taxonomyFieldName,
      'entity_type' => 'node',
      'type' => 'string',
      'settings' => [
        'vocabulary' => $this->vocabulary->get('vid'),
      ],
    ];
    FieldStorageConfig::create($fieldStorageTaxonomySelect)->save();
    $fieldTaxonomySelect = [
      'field_name' => $this->taxonomyFieldName,
      'entity_type' => 'node',
      'bundle' => 'select',
      'label' => 'Taxonomy Select',
    ];
    FieldConfig::create($fieldTaxonomySelect)->save();

    $form = \Drupal::service('entity_display.repository')->getFormDisplay('node', 'select', 'default')
      ->setComponent($this->filteredFieldName, [
        'type' => 'filterable_select',
      ])
      ->setComponent($this->taxonomyFieldName, [
        'type' => 'taxonomy_select',
      ]);
    $form->save();

    // Create and log in user.
    $test_user = $this->drupalCreateUser([
      'access content',
      'create select content',
      'edit any select content',
    ]);
    $this->drupalLogin($test_user);
  }

  /**
   * Create a vocabulary.
   */
  protected function createVocabulary($name) {
    $vocabulary = Vocabulary::create([
      'name' => $name,
      'description' => $name . 'description',
      'vid' => $this->randomMachineName(),
      'langcode' => LanguageInterface::LANGCODE_NOT_SPECIFIED,
      'help' => '',
    ]);
    $vocabulary->save();
    return $vocabulary;
  }

  /**
   * Add terms to a vocabulary.
   */
  protected function addTerms($vocabulary, $names) {
    foreach ($names as $name) {
      $term = Term::create([
        'name' => $name,
        'description' => $name . 'description',
        'vid' => $vocabulary->id(),
        'langcode' => LanguageInterface::LANGCODE_NOT_SPECIFIED,
      ]);
      $term->save();
    }
  }

}
