<?php

namespace Drupal\mposse;

use Drupal\Component\Plugin\PluginBase;

/**
 * A base class to help developers implement their own social platform plugins.
 *
 * @see \Drupal\mposse\Annotation\SocialPlatform
 * @see \Drupal\mposse\SocialPlatformInterface
 */
abstract class SocialPlatformBase extends PluginBase implements SocialPlatformInterface
{

  /**
   * {@inheritdoc}
   */
  public function label()
  {
    // Retrieve the @label property from the annotation and return it.
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function description()
  {
    // Retrieve the @description property from the annotation and return it.
    return $this->pluginDefinition['description'];
  }

  /**
   * {@inheritdoc}
   */
  public function maxCharCount()
  {
    // Retrieve the @max_char_count property from the annotation and return it.
    return (int) $this->pluginDefinition['max_char_count'];
  }

  /**
   * {@inheritdoc}
   */
  abstract public function postMicroblog(array $post_data);

}
