<?php

namespace Drupal\mposse\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure MPOSSE settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'mposse_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['mposse.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('mposse.settings');

    $form['soft_disable'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Soft disable'),
      '#description' => $this->t('This setting disables automated microblog posting without having to uninstall MPOSSE.'),
      '#default_value' => $config->get('soft_disable'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('mposse.settings')
      ->set('soft_disable', $form_state->getValue('soft_disable'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
