<?php

namespace Drupal\multi_domain_login\EventSubscriber;

use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Url;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\multi_domain_login\Event\UserLoginEvent;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Class UserLoginSubscriber.
 *
 * @package Drupal\multi_domain_login\EventSubscriber
 */
class UserLoginSubscriber implements EventSubscriberInterface {

  /** @var \Drupal\Core\Language\LanguageManagerInterface $languageManager */
  private $languageManager;

  /** @var \Drupal\Core\Routing\RouteMatchInterface $routeMatch */
  private $routeMatch;

  /**
   * @var \Symfony\Component\HttpFoundation\RequestStack $requestStack
   */
  private $requestStack;

  /**
   * UserLoginSubscriber constructor.
   *
   * @param \Drupal\Core\Language\LanguageManagerInterface $languageManager
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   */
  public function __construct(LanguageManagerInterface $languageManager,
                              RouteMatchInterface $routeMatch,
                              RequestStack $requestStack) {
    $this->languageManager = $languageManager;
    $this->routeMatch = $routeMatch;
    $this->requestStack = $requestStack;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      // -100 means very low priority.
      UserLoginEvent::EVENT_NAME => ['onUserLogin', -100],
    ];
  }

  /**
   * Subscribe to the user login event dispatched.
   *
   * @param UserLoginEvent $event
   *   Event object.
   */
  public function onUserLogin(UserLoginEvent $event) {
    $current_route = $this->routeMatch->getRouteName();

    if ($this->languageManager && $this->languageManager->isMultilingual()) {
      if (!in_array($current_route, ['user.reset', 'user.reset.login', 'multi_domain_login.login'])) {
        $current_request = $this->requestStack->getCurrentRequest();
        $current_request->query->set('destination', Url::fromRoute('multi_domain_login.domain')->toString());
      }
    }
  }

}
