(function($, Drupal, drupalSettings) {

    "use strict";

    Drupal.behaviors.multi_domain_login = {
        attach: function(context, settings) {

            var images = $('img.multi-domain-login-image');
            var timeout = 30000;
            var poll = 250;
            var count = 0;

            var updateDomainStatus = function (item, status) {
                var img = $(item);
                var domain = img.parent();

                domain.removeClass('multi-domain-login-verifying');
                domain.addClass('multi-domain-login-' + status);
                img.hide();
            };

            images
                .on('load', function() {
                    updateDomainStatus(this, 'verified');
                })
                .on('error', function() {
                    updateDomainStatus(this, 'error');
                })
            ;

            function pollDommainStatus() {

                var verifying = $('.multi-domain-login-verifying').length;

                count = count + poll;

                if (!verifying || count >= timeout) {
                    var status = ((verifying < 1) ? 'verified' : 'error');
                    var redirect = drupalSettings.multi_domain_login.redirect[status] || '';
                    location.href = Drupal.url(redirect);
                }
                else {
                    setTimeout(pollDommainStatus, poll);
                }
            }

            pollDommainStatus();
        }
    };

})(jQuery, Drupal, drupalSettings);
