# Multi Value Add Hider

This module prevents the default empty add form from appearing when editing an
unlimited multivalued field, except when the field has no existing values.

It helps keep the edit form clean and reduces unnecessary UI clutter while still
allowing new values to be added when needed.


For a full description of the module, visit the
[project page](https://www.drupal.org/project/multi_value_add_hider).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/multi_value_add_hider).


## Requirements

This module requires no modules outside of Drupal core 10.3+.


## Installation

Install as you would normally install a contributed Drupal module.
For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

Go to your multivalued field form display configuration and choose the
appropriate value in the **Hide empty add form** select list.

Here are the available options:

- **Disabled**: disable the feature, so the empty add form will always be shown.
- **Always hide**: hide the empty add form regardless of the field's current
  value.
- **Hide when field is not empty**: hide the empty add form only when the field
  has existing values, keep it visible when the field is empty.
- **Hide when field is empty but not required**: hide the empty add form only
  when the field has no existing values and is not required.


## Similar modules

- None found.


## Maintainers

- Frank Mably - [mably](https://www.drupal.org/u/mably)
