# Multi Menu UI

**Extends the core menu_ui sidebar** to support multiple menu links per node while maintaining **100% backwards compatibility**.

## Key Features

- ✅ **Backwards Compatible**: Existing single menu links continue to work via core menu_ui
- ✅ **Seamless Integration**: Extends the existing "Menu settings" sidebar (not a separate field)
- ✅ **Safe Degradation**: Module can be disabled without data loss (primary link remains intact)
- ✅ **AJAX Interface**: "Add another menu link" button with dynamic parent selection
- ✅ **Automatic Sync**: Additional menu links automatically synced to menu_link_content entities

## How It Works

### Primary Menu Link (Index 0)
The **first/primary menu link** is always managed by **core menu_ui**. This ensures:
- Full backwards compatibility with existing content
- Standard Drupal menu UI behavior
- The "Provide a menu link" checkbox works as expected
- Module can be safely disabled

### Additional Menu Links (Index 1+)
**Additional menu links** are managed by this module:
- Stored in a custom field (`field_additional_menu_links`)
- Displayed in the same "Menu settings" sidebar
- Independent from the primary link
- Automatically synced to menu_link_content entities

## Installation

```bash
drush en multi_menu_ui
```

**What happens on install:**
- Module is enabled and ready to use
- No fields are created automatically (opt-in per content type)
- Existing primary menu links remain untouched
- No data migration needed

**Enabling for a content type:**
1. Go to Structure > Content types > [Your Type] > Edit
2. Under "Menu settings", find the "Multi Menu UI" section
3. Check "Enable additional menu links"
4. Save the content type
5. The `field_additional_menu_links` field is automatically created

## Usage

### Enabling Multi Menu UI for a Content Type

1. Go to Structure > Content types > [Your Type] > Edit
2. Under "Menu settings" (only visible if menu_ui is enabled), find the "Multi Menu UI" section
3. Check "Enable additional menu links"
4. Save the content type
5. The field is automatically created and ready to use

### Creating Additional Menu Links

1. Edit any node of a content type with multi menu UI enabled
2. Check the **"Provide a menu link"** checkbox
3. You'll see the standard primary menu link fields
4. Below that (after a subtle divider), you'll see collapsed sections for additional menu links
5. Click **"Add another menu link"** to add more links
6. Expand each "Menu link 2", "Menu link 3", etc. section to configure:
   - Menu link title
   - Description
   - Parent link (with menu selection)
   - Weight
   - Enabled checkbox
7. Click **"Remove"** to delete an additional link
8. Save the node

**Note:** Additional menu links are only visible when the primary "Provide a menu link" checkbox is checked.

### UI Structure

```
┌─ Menu settings ─────────────────────────┐
│ ☑ Provide a menu link  (PRIMARY LINK)   │
│                                          │
│ Menu link title: [____________]          │
│ Description:     [____________]          │
│ Parent link:     [Hoofdmenu ▼]          │
│ Weight:          [0]                     │
│                                          │
│ ──────────────────────────────────────   │ (subtle divider)
│                                          │
│ ▶ Menu link 2  (collapsed details)      │
│ ▶ Menu link 3  (collapsed details)      │
│                                          │
│ [+ Add another menu link]                │
└──────────────────────────────────────────┘

When expanded, each additional link shows:
┌─ Menu link 2 ───────────────────────────┐
│ Menu link title: [____________]          │
│ Description:     [____________]          │
│ Parent link:     [Footer ▼]             │
│ Weight:          [0]                     │
│ ☑ Enabled                                │
│ [Remove]                                 │
└──────────────────────────────────────────┘

Note: Additional menu links section is hidden when
"Provide a menu link" checkbox is unchecked.
```

## Architecture

### Data Flow

```
PRIMARY LINK (managed by core menu_ui):
  Node Form → Core menu_ui hooks → menu_link_content entity (ID 1)

ADDITIONAL LINKS (managed by multi_menu_ui):
  Node Form → form_alter → field_additional_menu_links
           → entity hooks → AdditionalMenuLinkSyncService
           → menu_link_content entities (ID 2+)
           → UUID tracking in field
```

### Components

1. **AdditionalMenuLinkItem** - Field type for additional links only
2. **AdditionalMenuLinkSyncService** - Syncs additional links (excludes primary)
3. **form_alter hook** - Extends menu_ui sidebar with additional link UI
4. **Submit handlers** - Saves additional links to field
5. **Entity hooks** - Triggers sync on node save/delete

## Backwards Compatibility

### What Happens When Module is Disabled?

✅ **Primary menu link**: Remains fully functional (managed by core menu_ui)
⚠️ **Additional menu links**: Hidden from UI (field data preserved, menu_link_content entities deleted)

### What Happens When Module is Re-enabled?

✅ **Primary menu link**: Unchanged
✅ **Additional menu links**: Field data restored, menu_link_content entities recreated

### Migrating from Old Approach

If you previously used the standalone `multi_menu_link` field type:
1. The new `additional_menu_link` field type is separate
2. Migrate your first menu link to core menu_ui (if needed)
3. Additional links can use the new field type
4. Both field types can coexist during migration

## Edge Cases Handled

### 1. Primary Link Disabled via Checkbox
- Core menu_ui deletes the primary link
- Additional links remain unaffected (they're independent)

### 2. Primary Link Changed to Different Menu
- Core menu_ui handles the update
- Additional links unaffected

### 3. Node Deleted
- Core menu_ui deletes primary link
- multi_menu_ui deletes additional links
- No orphaned menu_link_content entities

### 4. Module Disabled then Re-enabled
- Primary link: unchanged (core menu_ui)
- Additional links: field data preserved, entities recreated on next save

## Limitations

1. **Entity type**: Only works with nodes (not other content entity types)
2. **Translations**: Only default language creates menu links (by design, avoids duplicates)
3. **Revisions**: Menu links not revision-aware (always reference latest node)
4. **Primary link**: Always managed by core menu_ui (cannot be moved to additional links)
5. **Performance**: Many additional links may impact form rendering

## Technical Details

- **PHP**: 8.1+ with strict types
- **Drupal**: 10, 11, or 12
- **Coding Standards**: Drupal coding standards, PHP 8 attributes
- **Dependencies**: link, menu_link_content, node (core modules)

## Troubleshooting

### Additional Links Not Appearing

1. Check that the content type has menu_ui enabled
2. Go to Structure > Content types > [Your Type] > Edit > Menu settings
3. Verify "Enable additional menu links" checkbox is checked
4. Verify `field_additional_menu_links` field exists on the content type
5. Make sure the "Provide a menu link" checkbox is checked on the node edit form
6. Clear cache: `drush cr`

### Primary Link Not Working

This is managed by core menu_ui. Check:
1. Menu UI module is enabled
2. Content type has "Available menus" configured
3. User has "Administer menu" permission

### Links Not Syncing

1. Check logs: `drush watchdog:show --type=multi_menu_ui`
2. Verify the sync service is registered: `drush ev "var_dump(get_class(\Drupal::service('multi_menu_ui.sync_service')));"`
3. Check for PHP errors in the error log

## Development

### Running Tests

```bash
drush en multi_menu_ui
cd /path/to/drupal
vendor/bin/phpunit -c web/core/phpunit.xml.dist web/modules/custom/multi_menu_ui/tests
```

### Debugging

Enable debug logging:
```php
// In settings.php
$config['system.logging']['error_level'] = 'verbose';
```

Watch logs:
```bash
drush watchdog:tail --type=multi_menu_ui
```

## Credits

- **Approach**: Extends core menu_ui (backwards compatible)
- **Inspiration**: Core menu_ui module architecture
- **Pattern**: Form alter + field storage + entity hooks

## License

GPL-2.0-or-later
