<?php

// phpcs:disable Drupal.WhiteSpace.OpenTagNewline.BlankLine
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.FileComment.NamespaceNoFileDoc
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\multiple_email\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access check for the multiple_email.manage route.
 */
class MultipleEmailPageAccess implements AccessInterface {

  /**
   * The administration permission.
   *
   * @var string
   */
  const string ADMIN_PERMISSION = 'administer multiple emails';

  /**
   * The permission necessary to get multiple_email entities.
   *
   * @var string
   */
  const string USER_PERMISSION = 'use multiple emails';

  /**
   * Checks the access to the multiple_email personal tab.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match object to be checked.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged-in account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(RouteMatchInterface $route_match, AccountInterface $account): AccessResultInterface {
    $user = $route_match->getParameter('user');

    // Anonymous users do not have multiple_email entities.
    if ($user->isAnonymous()) {
      return AccessResult::forbidden();
    }

    if ($account->hasPermission(self::ADMIN_PERMISSION)) {
      return AccessResult::allowed()->cachePerPermissions();
    }

    if ($account->hasPermission(self::USER_PERMISSION) && $account->id() == $user->id()) {
      return AccessResult::allowed()
        ->cachePerPermissions()
        ->cachePerUser();
    }

    return AccessResult::forbidden()->cachePerPermissions();
  }

}
