<?php

// phpcs:disable Drupal.WhiteSpace.OpenTagNewline.BlankLine
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.FileComment.NamespaceNoFileDoc
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\multiple_email;

/**
 * Interface for defining the email confirmer service.
 */
interface EmailConfirmerInterface {

  /**
   * Confirms an email address.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address to confirm.
   */
  public function confirm(EmailInterface $email);

  /**
   * Cancels a confirmation attempt.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address of the confirmation attempt to cancel.
   */
  public function cancelConfirmation(EmailInterface $email);

  /**
   * Expires an email address.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address to expire.
   */
  public function expire(EmailInterface $email);

}
