<?php

// phpcs:disable Drupal.WhiteSpace.OpenTagNewline.BlankLine
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.FileComment.NamespaceNoFileDoc
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\multiple_email;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the storage handler class for email entities.
 */
class EmailStorage extends SqlContentEntityStorage implements EmailStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function loadByUser(AccountInterface $account): array {
    return $this->loadByProperties(['uid' => $account->id()]);
  }

  /**
   * {@inheritdoc}
   */
  public function loadByEmail(string $email): EmailInterface|false {
    $email = $this->loadByProperties(['email' => $email]);

    return reset($email);
  }

}
