<?php

// phpcs:disable Drupal.WhiteSpace.OpenTagNewline.BlankLine
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.FileComment.NamespaceNoFileDoc
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\multiple_email;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines an interface for email entity storage classes.
 */
interface EmailStorageInterface extends ContentEntityStorageInterface {

  /**
   * Loads all the multiple_email entities for an account.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The account for which the multiple_email entities are loaded.
   *
   * @return \Drupal\multiple_email\EmailInterface[]
   *   An array of multiple_email entities.
   */
  public function loadByUser(AccountInterface $account): array;

  /**
   * Loads a multiple_email entity by email.
   *
   * @param string $email
   *   The email address to search.
   *
   * @return \Drupal\multiple_email\EmailInterface|false
   *   The loaded multiple_email entity, or FALSE.
   */
  public function loadByEmail(string $email): EmailInterface|false;

}
