<?php

// phpcs:disable Drupal.WhiteSpace.OpenTagNewline.BlankLine
// phpcs:disable SlevomatCodingStandard.TypeHints.DeclareStrictTypes.IncorrectWhitespaceBeforeDeclare
// phpcs:disable Drupal.Commenting.DocComment.MissingShort
// phpcs:disable Drupal.Commenting.FileComment.NamespaceNoFileDoc
// phpcs:disable Drupal.Commenting.DocComment.ContentAfterOpen
/** @noinspection PhpUnused */
/** @noinspection PhpUnusedParameterInspection */
/** @noinspection PhpUndefinedClassInspection */
/** @noinspection PhpUndefinedNamespaceInspection */

declare(strict_types=1);

// phpcs:enable

namespace Drupal\multiple_email;

use Drupal\views\EntityViewsData;

/**
 * Provides a relationship between user and multiple_email entities.
 */
class EmailViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    $data = parent::getViewsData();

    $data['users']['multiple_email_relationship'] = [
      'title' => $this->t('Multiple emails'),
      'help' => $this->t('Relate a user account to multiple email records.'),
      'relationship' => [
        'group' => $this->t('Multiple email'),
        'label' => $this->t('Multiple emails'),
        'base' => 'multiple_email',
        'base field' => 'uid',
        'relationship field' => 'uid',
        'id' => 'multiple_email_relationship',
      ],
    ];

    return $data;
  }

}
