<?php

declare(strict_types=1);

namespace Drupal\multiple_email;

/**
 * Interface for defining the email confirmer service.
 */
interface EmailConfirmerInterface {

  /**
   * Confirms an email address.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address to confirm.
   */
  public function confirm(EmailInterface $email);

  /**
   * Cancels a confirmation attempt.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address of the confirmation attempt to cancel.
   */
  public function cancelConfirmation(EmailInterface $email);

  /**
   * Expires an email address.
   *
   * @param \Drupal\multiple_email\EmailInterface $email
   *   The email address to expire.
   */
  public function expire(EmailInterface $email);

}
