<?php

declare(strict_types=1);

namespace Drupal\multiple_email;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the storage handler class for email entities.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class EmailStorage extends SqlContentEntityStorage implements EmailStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function loadByUser(AccountInterface $account): array {
    return $this->loadByProperties(['uid' => $account->id()]);
  }

  /**
   * {@inheritdoc}
   */
  public function loadByEmail(string $email): EmailInterface|false {
    $email = $this->loadByProperties(['email' => $email]);

    return reset($email);
  }

}
