<?php

declare(strict_types=1);

namespace Drupal\multiple_email;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines an interface for email entity storage classes.
 */
interface EmailStorageInterface extends ContentEntityStorageInterface {

  /**
   * Loads all the email address entities for an account.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The account for which the email address entities are loaded.
   *
   * @return \Drupal\multiple_email\EmailInterface[]
   *   An array of email address entities.
   */
  public function loadByUser(AccountInterface $account): array;

  /**
   * Loads an email address entity by email.
   *
   * @param string $email
   *   The email address to search.
   *
   * @return \Drupal\multiple_email\EmailInterface|false
   *   The loaded email address entity, or FALSE.
   */
  public function loadByEmail(string $email): EmailInterface|false;

}
