<?php

declare(strict_types=1);

namespace Drupal\multiple_email;

use Drupal\views\EntityViewsData;

/**
 * Provides a relationship between user and email address entities.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class EmailViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    $data = parent::getViewsData();

    $data['users']['multiple_email_relationship'] = [
      'title' => $this->t('Multiple emails'),
      'help' => $this->t('Relate a user account to its email address entities.'),
      'relationship' => [
        'group' => $this->t('Multiple email'),
        'label' => $this->t('Email addresses'),
        'base' => 'multiple_email',
        'base field' => 'uid',
        'relationship field' => 'uid',
        'id' => 'multiple_email_relationship',
      ],
    ];

    return $data;
  }

}
