<?php

declare(strict_types=1);

namespace Drupal\multiple_email\Form;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Form for cancelling an email address confirmation.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class ConfirmCancelForm extends AjaxConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'multiple_email_confirm_cancel';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDescription(): TranslatableMarkup {
    return $this->t('Are you sure you want to cancel the confirmation of %email?', [
      '%email' => $this->email->getEmail(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  protected function doAction(): void {
    $this->emailConfirmer->cancelConfirmation($this->email);
  }

}
