<?php

declare(strict_types=1);

namespace Drupal\multiple_email\Form;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Form for confirming an email address.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class ConfirmConfirmForm extends AjaxConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'multiple_email_confirm_confirm';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDescription(): TranslatableMarkup {
    return $this->t('Are you sure you want to confirm %email?', [
      '%email' => $this->email->getEmail(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  protected function doAction(): void {
    $this->emailConfirmer->confirm($this->email);
  }

}
