<?php

declare(strict_types=1);

namespace Drupal\multiple_email\Form;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Form for removing an email address.
 *
 * @internal
 *
 * @see https://www.drupal.org/node/3565417
 */
class ConfirmDeleteForm extends AjaxConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'multiple_email_confirm_delete';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDescription(): TranslatableMarkup {
    return $this->t('Are you sure you want to delete %email?', [
      '%email' => $this->email->getEmail(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  protected function doAction(): void {
    $this->email->delete();
  }

}
